//	ADFS_Prefs.c

#ifndef __GNUC__
	#include <Files.h>
#endif

#include "GenStructs.h"
#include "MemUtils.h"
#include "FSUtils.h"
#include "IC_Errors.h"
#include "ADFS_Prefs.h"

ADFS_PrefsHandle	gPrefsH;
short				gAppResFile, gPrefResFile;

static	void		FillInNewPrefs(ADFS_PrefsHandle prefsH)
{
	Rect		emptyR = { 0, 0, 0, 0 };
	short		loop;
	
	structclr(**prefsH);
	
	(**prefsH).prefVers			= kADFS_PrefsVers;
	(**prefsH).prefProgMenuS	= kPref_MID_ShowProgAfter_1;
	
	(**prefsH).copyTwirledDown	= FALSE;
	(**prefsH).loggingB			= FALSE;
	(**prefsH).detokenizeB		= FALSE;
	(**prefsH).redBackgroundB	= FALSE;
	(**prefsH).blackAndWhiteB	= FALSE;
	
	(**prefsH).newDiskRec.diskP					= NULL;
	(**prefsH).newDiskRec.format.sectorOrder	= FSType_PRO;
	(**prefsH).newDiskRec.format.nibblizedB		= FALSE;
	(**prefsH).newDiskRec.format.diskFileType	= ND_Format_RAW;
	(**prefsH).newDiskRec.bytesOnDiskL			= Gen_kBytesPerDisk;
	(**prefsH).newDiskRec.bootableB				= TRUE;
	(**prefsH).newDiskRec.customSizeB			= FALSE;
	(**prefsH).newDiskRec.isMB					= FALSE;
	(**prefsH).newDiskRec.osType				= FSType_PRO;
	(**prefsH).newDiskRec.NewDiskDoneCB			= NULL;

	(**prefsH).numWindows								= kNumWindowPrefs;
	(**prefsH).windowPrefs[kDTWindIndex].windR			= emptyR;
	(**prefsH).windowPrefs[kDTWindIndex].arrangeBy		= ADFS_Stat_INDEX;
	(**prefsH).windowPrefs[kDTWindIndex].reversedB		= FALSE;
	(**prefsH).windowPrefs[kDTWindIndex].viewAs			= ADFS_ViewAs_LIST;

	(**prefsH).windowPrefs[kDTWindIndex].numColumns		= ADFS_Stat_NUMTYPES;
	for (loop = 0; loop < ADFS_Stat_NUMTYPES; loop++) {
		(**prefsH).windowPrefs[kDTWindIndex].columnWidths[loop] = gStats[loop].width;
	}
}

static	OSErr		UsePrefResFile(FSSpec *resFileSpecP)
{
	OSErr		err = noErr;
	
	if (!err) {
		gPrefResFile = FSpOpenResFile(resFileSpecP, fsRdWrPerm);
		
		if (gPrefResFile == -1) {
			err = ResError();
		}
	}

	if (!err) {
		UseResFile(gPrefResFile);
		err = ResError();
	}

	return err;
}

static	OSErr		CopyResFromApp(
	OSType	osType, 
	short	readID, 
	short	writeID, 
	Str255	writeName)
{
	OSErr		err = noErr;
	Handle		prefH = NULL, tempH = NULL;
	
	if (!err) {
		UseResFile(gAppResFile);
		err = ResError();
	}

	if (!err) prefH = GetResource(osType, readID);
	if (prefH == NULL) err = IC_Err_COULD_NOT_LOAD_PREFS;

	if (!err) {
		DetachResource(prefH);
		err = ResError();
		
		if (err) {
			Handle		oldH = prefH;
			
			err = HandToHand(&prefH);
			ReleaseResource(oldH);
		}
	}
	
	if (!err) {
		UseResFile(gPrefResFile);
		err = ResError();
	}
	
	if (!err) tempH = GetResource(osType, writeID);
	if (tempH != NULL) {
		RemoveResource(tempH);
		err = ResError();
		
		if (!err) {
			DisposeHandle(tempH);
			err = MemError();
		}
	}
	if (!err) {
		AddResource(prefH, osType, writeID, writeName);
		err = ResError();
	}

	if (!err) {
		UpdateResFile(gPrefResFile);
		err = ResError();
	}

	if (!err) {
		DisposeHandle(prefH);
		err = MemError();
	}
	
	return err;
}

#define		kPrefResType		'pref'

OSErr		LoadPrefs(void)
{
	OSErr		err;
	FSSpec		prefsFolderFSp;
	FSSpec		prefsFSp;
	Boolean		newPrefsB = FALSE, outOfDateB = FALSE;	
	
	ASSERT(sizeof(FSType) == sizeof(Byte));
	
	gAppResFile = CurResFile();

	//	find the prefs folder
	err = FSpFindFolder(kOnSystemDisk, kPreferencesFolderType, &prefsFolderFSp);
		
	//	make a filespec for the prefs file
	if (!err) {
		char	prefAC[32];
		
		#ifdef __ROSE__
			strcpy(prefAC, "Rose Prefs");
		#else
			strcpy(prefAC, "ADFS Prefs");
		#endif
		
		err = FSpMakeFSSpecFromFolderAndCName(&prefsFolderFSp, prefAC, &prefsFSp);
		
	}
	
	//	if it ain't there, make it
	if (err == fnfErr) {
		err			= noErr;
		newPrefsB	= TRUE;
		
		FSpCreateResFile(&prefsFSp, GetAppCreator(), kPrefResType, NULL);
		err = ResError();
	}
	
	//	check to see that we have a default prefs resource
	if (!err) {
		UseResFile(gAppResFile);
		err = ResError();
	}
	
	if (!err) gPrefsH = (ADFS_PrefsHandle)GetResource(kPrefResType, 128);
	if (gPrefsH == NULL) {
		gPrefsH = (ADFS_PrefsHandle)TrackNewHandle("prefs rec", sizeof(ADFS_PrefsRec));
		if (gPrefsH == NULL) err = IC_Err_COULD_NOT_LOAD_PREFS;
		
		if (!err) {
			FillInNewPrefs(gPrefsH);
			
			AddResource((Handle)gPrefsH, kPrefResType, 128, "\p");
			err = ResError();
		}
		
		if (!err) err = SavePrefs();
	};

	//	now use the prefs res file
	if (!err) err = UsePrefResFile(&prefsFSp);

	if (!newPrefsB) {
		//	check to see if we're out of date
		if (!err) gPrefsH = (ADFS_PrefsHandle)GetResource(kPrefResType, 128);
		if (gPrefsH == NULL) err = IC_Err_COULD_NOT_LOAD_PREFS;
		
		if (!err) {
			if ((**gPrefsH).prefVers != kADFS_PrefsVers) {
				outOfDateB = TRUE;
			}
		}
	}
	
	//	if the prefs resource ain't there, or, if it's there and it's out of date
	//	then copy the prefs from the app into it
	if (newPrefsB || outOfDateB) {
		if (!err) err = CopyResFromApp(kPrefResType, 128, 128, c2p(""));
		//if (!err) err = CopyResFromApp('TMPL', 130, 128, "\ppref");
	}

	// now, get the prefs resource
	if (!err) gPrefsH = (ADFS_PrefsHandle)GetResource(kPrefResType, 128);
	if (gPrefsH == NULL) err = IC_Err_COULD_NOT_LOAD_PREFS;

	if (err) {
		ReportError(IC_Err_COULD_NOT_LOAD_PREFS);
	}
	
	return err;
}

OSErr		SavePrefs(void)
{
	OSErr		err = noErr;
	
	if (!err) {
		ChangedResource((Handle)gPrefsH);
		err = ResError();
	}
	
	if (!err) {
		WriteResource((Handle)gPrefsH);
		err = ResError();
	}
	
	if (err) {
		ReportError(IC_Err_COULD_NOT_LOAD_PREFS);
	}

	return err;
}

